<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Module extends Model 
{

    protected $table = 'modules';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function course()
    {
        return $this->belongsTo('Course');
    }

    public function lessons()
    {
        return $this->hasMany('Lesson');
    }

}